﻿#include  "StdAfx.h"

#include  <szCodecManager.hpp>
#include  <szArchiveDetector.hpp>
#include  <szArchiveEnumerator.hpp>
#include  <szArchiveContent.hpp>
#include  <szStoredItem.hpp>
#include  <szRuntimeException.hpp>
#include  <szFileArchiveVolume.hpp>
#include  <szPath.hpp>
#include  <szFile.hpp>

#include  <cstdio>
#include  <clocale>

int _tmain(int argc, _TCHAR* argv[])
{
  using namespace std;
  using namespace szpp;

  //locale::global(locale("japanese"));

  if (2 != argc)
  {
    _ftprintf(stderr, SZL("Usage: DetectTest utf8_listfile\n"));
    return 1;
  }

  OnClientStartup(GetModuleHandle(0));
  SetCurrentTextCatalogPath(SZL("ja.lng"));

  FILE  *fp = 0;
  szchar buffer[1024];
  _tfopen_s(&fp, argv[1], SZL("r, ccs=UTF-8"));
  if (fp != 0)
  {
    while (_fgetts(buffer, 1024, fp) != 0)
    {
      szstring path(buffer);
      if (*path.rbegin() == SZL('\n'))
        path = path.substr(0, path.size() - 1);

      if (!FileExists(path))
        continue;

      FileArchiveVolume archiveVolume(path);
      ArchiveHandler   *handler = 0;
      std::auto_ptr<ArchiveContent> content(ArchiveEnumerator::EnumerateUnknown(&handler, &archiveVolume, 1024 * 1000, 0, 0));
      
      _tprintf(SZL("%s: %s "), path.c_str(), handler != 0 ? handler->GetName() : SZL("UNKNOWN"));
      if (content.get() != 0)
      {
        _tprintf(SZL("%d/%d "),
          content->GetArchiveProperty().GetCompressedSize(),
          content->GetArchiveProperty().GetUncompressedSize());
        _tprintf(SZL("%c%c "),
          content->GetArchiveProperty().GetIsMultivolume() ? 'V' : '-',
          content->GetArchiveProperty().GetIsSolid() ? 'S' : '-');
      }
      _tprintf(SZL("\n"));

      delete handler;
    }
    fclose(fp);
  }

  OnClientShutdown();

	return 0;
}
